/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.DoggyItems;
import doggytalents.api.anim.DogAnimation;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogItem;
import doggytalents.client.screen.DogAnimDebugScreen;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.anim.DogAnimationManager;
import doggytalents.common.util.ItemUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class DogAnimDebugItem
extends Item
implements IDogItem {
    public static final String SELECT_ANIM_ID = "dtn_selected_id";
    public static final String ITEM_MODE_ID = "dtn_item_mode";

    public DogAnimDebugItem(Item.Properties p_41383_) {
        super(p_41383_.m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (level.f_46443_) {
            DogAnimDebugScreen.open(player);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    @Override
    public InteractionResult processInteract(AbstractDog dogIn, Level worldIn, Player playerIn, InteractionHand handIn) {
        if (!dogIn.m_9236_().f_46443_) {
            this.useActionOnDog(dogIn, playerIn);
        }
        return InteractionResult.SUCCESS;
    }

    private void useActionOnDog(AbstractDog dogIn, Player player) {
        if (!(dogIn instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)dogIn;
        if (!player.m_20310_(4)) {
            return;
        }
        if (!player.m_7500_()) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() != this) {
            return;
        }
        ItemMode item_mode = DogAnimDebugItem.getItemMode(stack);
        DogAnimationManager anim_manager = dog.animationManager;
        switch (item_mode) {
            case ANIM: {
                if (player.m_6144_()) {
                    anim_manager.setDogAnimDebugState(DogAnimationManager.DogAnimDebugState.NONE);
                    return;
                }
                DogAnimation anim = DogAnimDebugItem.getSelectedAnimation(stack);
                if (anim.isNone()) {
                    anim_manager.setDogAnimDebugState(DogAnimationManager.DogAnimDebugState.NONE);
                    return;
                }
                DogAnimationManager.DogAnimDebugState debug_state = dog.getDogAnimDebugState();
                if (debug_state.anim() != anim) {
                    anim_manager.setDogAnimDebugState(DogAnimationManager.DogAnimDebugState.of(anim, 0, 0.0f));
                    dog.setAnim(anim);
                    return;
                }
                if (dog.getAnim().isNone()) {
                    dog.setAnim(anim);
                } else {
                    anim_manager.setDogAnimDebugState(dog.animationManager.getFreezeDebugState(anim));
                    dog.setAnim(DogAnimation.NONE);
                }
                return;
            }
            case TIME_SET: {
                if (!dog.isDogInAnimDebug()) {
                    return;
                }
                DogAnimationManager.DogAnimDebugState debug_state = dog.getDogAnimDebugState();
                DogAnimation anim = debug_state.anim();
                if (anim.isNone()) {
                    return;
                }
                int new_timestamp = debug_state.timestamp() + (player.m_6144_() ? -1 : 1);
                new_timestamp = Mth.m_14045_((int)new_timestamp, (int)0, (int)anim.getLengthTicks());
                anim_manager.setDogAnimDebugState(DogAnimationManager.DogAnimDebugState.of(anim, new_timestamp, debug_state.yRot()));
                return;
            }
            case YROT: {
                anim_manager.setDebugFreezeYRot(player.f_20885_);
                return;
            }
        }
    }

    public boolean m_5812_(ItemStack p_41453_) {
        return true;
    }

    public static DogAnimation getSelectedAnimation(ItemStack stack) {
        CompoundTag tag = ItemUtil.getTag(stack);
        if (!tag.m_128425_(SELECT_ANIM_ID, 3)) {
            return DogAnimation.NONE;
        }
        int anim_id = tag.m_128451_(SELECT_ANIM_ID);
        DogAnimation anim = DogAnimation.byId(anim_id);
        return anim;
    }

    public static ItemMode getItemMode(ItemStack stack) {
        CompoundTag tag = ItemUtil.getTag(stack);
        if (!tag.m_128425_(ITEM_MODE_ID, 3)) {
            return ItemMode.ANIM;
        }
        int mode_id = tag.m_128451_(ITEM_MODE_ID);
        ItemMode mode = ItemMode.fromId(mode_id);
        return mode;
    }

    public static void editDebugAnimStack(ItemStack stack, @Nullable DogAnimation selected, @Nullable ItemMode mode) {
        if (stack.m_41720_() != DoggyItems.DOG_ANIM_DEBUG.get()) {
            return;
        }
        CompoundTag tag = ItemUtil.getTag(stack);
        if (selected != null) {
            tag.m_128405_(SELECT_ANIM_ID, selected.getId());
        }
        if (mode != null) {
            tag.m_128405_(ITEM_MODE_ID, mode.getId());
        }
        ItemUtil.putTag(stack, tag);
    }

    public void m_7373_(ItemStack stack, Level context, List<Component> components, TooltipFlag flags) {
        String desc_id = "item.doggytalents.dog_anim_debug_stick.help";
        components.add((Component)Component.m_237115_((String)desc_id).m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true))));
    }

    public static enum ItemMode {
        ANIM(0),
        TIME_SET(1),
        YROT(2);

        private final int id;

        private ItemMode(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static ItemMode fromId(int id) {
            ItemMode[] values = ItemMode.values();
            if (id < 0 || id >= values.length) {
                return ANIM;
            }
            return values[id];
        }

        public ItemMode cycleMode() {
            ItemMode[] modes = ItemMode.values();
            int current_id = this.getId();
            int new_id = current_id + 1;
            if (new_id >= modes.length) {
                new_id = 0;
            }
            ItemMode new_mode = ItemMode.fromId(new_id);
            return new_mode;
        }
    }
}

